%% Analysis and plotting for .mat files from Sams Labview code V1.0
% Paul Gow

clear all
close all

files = ls('*.mat');  %saves list of files in current directory

%setting arrays to fill
thz_data = [];
peak = [];
Temps = [];
jjj = 1;    %increments for the for loop as some files wil be discarded


%% Running program
for ii = 1:size(files,1)
        src = load(files(ii,:));      %loads files one at a time
        discard = length(strfind(src.description,'[drop]'));
        if  discard == 0    %ingnores files comment [drop]
            Temps(jjj,:) = src.temperature;
            peak(jjj,:) = src.signal;
            jjj = jjj + 1;
        end
        
        
end

time = src.t;


%% Plotting
plot(time,peak);
xlabel('Temperature (K)');
ylabel('Peak-to-peak THz power (a.u)');
%axis([0 0.15 0 max(avg)+min(avg)]); 
%title('15 um, TM, fsat= 1.8 J/m^2');
legend(strcat(num2str(Temps),' K'));


%save('7umpowerte.txt','f','avg','serr', '-ascii');
%save('peak_Al.txt','peak','-ascii');


